% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained_indices.R
\name{rlpsi}
\alias{rlpsi}
\title{Restricted Linear Phenotypic Selection Index (RLPSI)}
\usage{
rlpsi(pmat, gmat, wmat, wcol = 1, restricted_traits = NULL, C = NULL, GAY)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits)}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits)}

\item{wmat}{Weight matrix (n_traits x k), or vector}

\item{wcol}{Weight column number (default: 1)}

\item{restricted_traits}{Vector of trait indices to restrict (default: NULL).
If provided, a constraint matrix C is auto-generated to enforce zero gain on these traits.
Example: c(1, 3) restricts traits 1 and 3 to zero gain.}

\item{C}{Constraint matrix (n_traits x n_constraints). Each column is a restriction.
Alternative to restricted_traits for custom constraints. Ignored if restricted_traits is provided.}

\item{GAY}{Genetic advance of comparative trait (optional)}
}
\value{
List with:
  \itemize{
    \item \code{summary} - Data frame with coefficients (b.*), GA, PRE, Delta_G, rHI, hI2
    \item \code{b} - Numeric vector of selection index coefficients
    \item \code{Delta_G} - Named vector of realized correlated responses per trait
    \item \code{C} - Constraint matrix used
  }
}
\description{
Implements the Restricted LPSI where genetic gains are constrained to zero
for specific traits while maximizing gains for others.
Based on Kempthorne & Nordskog (1959).
}
\details{
\strong{Mathematical Formulation (Chapter 3, Section 3.1):}

The RLPSI minimizes the mean squared difference between I = b'y and H = w'g
subject to the restriction: C'Delta_G = 0

Coefficient formula:
\deqn{b_r = [I - P^{-1}GC(C'GP^{-1}GC)^{-1}C'G]P^{-1}Gw}

Where:
- P = Phenotypic variance-covariance matrix
- G = Genotypic variance-covariance matrix
- C = Constraint matrix (each column enforces one restriction)
- w = Economic weights

The constraint C'Delta_G = 0 ensures zero genetic gain for restricted traits.
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
wmat <- weight_mat(weight)

# Easy way: Restrict traits 1 and 3 to zero gain
result <- rlpsi(pmat, gmat, wmat, wcol = 1, restricted_traits = c(1, 3))

# Advanced way: Provide custom constraint matrix
C <- diag(ncol(pmat))[, 1, drop = FALSE]
result <- rlpsi(pmat, gmat, wmat, wcol = 1, C = C)
}
}
