% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_eigen_indices.R
\name{rgesim}
\alias{rgesim}
\title{Restricted Linear Genomic Eigen Selection Index Method (RGESIM)}
\usage{
rgesim(pmat, gmat, Gamma, U_mat, selection_intensity = 2.063)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).}

\item{Gamma}{Covariance between phenotypes and GEBVs (n_traits x n_traits).}

\item{U_mat}{Restriction matrix (r x n_traits) where r is number of restrictions.
Each row specifies a linear combination of traits to be held at zero gain.}

\item{selection_intensity}{Selection intensity constant \eqn{k_I}
(default: 2.063 for 10\% selection).}
}
\value{
Object of class \code{"rgesim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with coefficients and metrics.}
  \item{\code{b_y}}{Coefficients for phenotypic data.}
  \item{\code{b_gamma}}{Coefficients for GEBVs.}
  \item{\code{b_combined}}{Combined coefficient vector.}
  \item{\code{E_RG}}{Expected genetic gains per trait.}
  \item{\code{constrained_response}}{U' * E (should be near zero).}
  \item{\code{sigma_I}}{Standard deviation of the index.}
  \item{\code{hI2}}{Index heritability.}
  \item{\code{rHI}}{Accuracy.}
  \item{\code{R_RG}}{Selection response.}
  \item{\code{lambda2}}{Leading eigenvalue.}
  \item{\code{implied_w}}{Implied economic weights.}
  \item{\code{K_RG}}{Projection matrix.}
  \item{\code{Q_RG}}{Constraint projection matrix.}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Implements the RGESIM which extends GESIM to allow restrictions on genetic
gains of certain traits. Uses the eigen approach with Lagrange multipliers.
}
\details{
\strong{Eigenproblem (Section 8.4):}
\deqn{(\mathbf{K}_{RG}\mathbf{\Phi}^{-1}\mathbf{A} - \lambda_{RG}^2 \mathbf{I}_{2t})\boldsymbol{\beta}_{RG} = 0}

where:
\deqn{\mathbf{K}_{RG} = \mathbf{I}_{2t} - \mathbf{Q}_{RG}}
\deqn{\mathbf{Q}_{RG} = \mathbf{\Phi}^{-1}\mathbf{A}\mathbf{U}_G(\mathbf{U}_G^{\prime}\mathbf{A}\mathbf{\Phi}^{-1}\mathbf{A}\mathbf{U}_G)^{-1}\mathbf{U}_G^{\prime}\mathbf{A}}

\strong{Implied economic weights:}
\deqn{\mathbf{w}_{RG} = \mathbf{A}^{-1}[\mathbf{\Phi} + \mathbf{Q}_{RG}^{\prime}\mathbf{A}]\boldsymbol{\beta}_{RG}}

\strong{Selection response:}
\deqn{R_{RG} = k_I \sqrt{\boldsymbol{\beta}_{RG}^{\prime}\mathbf{\Phi}\boldsymbol{\beta}_{RG}}}

\strong{Expected genetic gain per trait:}
\deqn{\mathbf{E}_{RG} = k_I \frac{\mathbf{A}\boldsymbol{\beta}_{RG}}{\sqrt{\boldsymbol{\beta}_{RG}^{\prime}\mathbf{\Phi}\boldsymbol{\beta}_{RG}}}}
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Simulate GEBV covariance
Gamma <- gmat * 0.8

# Restrict first trait to zero gain
# U_mat must be (n_traits x n_restrictions)
n_traits <- nrow(gmat)
U_mat <- matrix(0, n_traits, 1)
U_mat[1, 1] <- 1 # Restrict trait 1

result <- rgesim(pmat, gmat, Gamma, U_mat)
print(result)
print(result$constrained_response) # Should be near zero
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 8.4.
}
