% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen_indices.R
\name{resim}
\alias{resim}
\title{Restricted Linear Phenotypic Eigen Selection Index (RESIM)}
\usage{
resim(
  pmat,
  gmat,
  restricted_traits = NULL,
  U_mat = NULL,
  selection_intensity = 2.063
)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).}

\item{restricted_traits}{Integer vector of trait indices to restrict to zero
genetic gain.  Example: \code{c(1, 3)} restricts traits 1 and 3.
Alternatively supply a custom restriction matrix via \code{U_mat}.}

\item{U_mat}{Optional. Restriction matrix (n_traits x r) where each column
defines one null restriction (\eqn{\mathbf{U}^{\prime}\mathbf{C}\mathbf{b} = 0}).
Ignored if \code{restricted_traits} is provided.}

\item{selection_intensity}{Selection intensity constant (default: 2.063).}
}
\value{
Object of class \code{"resim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with b coefficients and key metrics.}
  \item{\code{b}}{Named numeric vector of RESIM coefficients.}
  \item{\code{Delta_G}}{Named vector of expected genetic gains per trait.}
  \item{\code{sigma_I}}{Index standard deviation.}
  \item{\code{hI2}}{Index heritability (leading eigenvalue of KP^(-1)C).}
  \item{\code{rHI}}{Index accuracy.}
  \item{\code{lambda2}}{Leading eigenvalue of the restricted eigenproblem.}
  \item{\code{K}}{Projection matrix used.}
  \item{\code{U_mat}}{Restriction matrix used.}
  \item{\code{restricted_traits}}{Integer vector of restricted trait indices.}
  \item{\code{implied_w}}{Implied economic weights.}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Extends ESIM by imposing null restrictions: genetic gains for \eqn{r} selected
traits are forced to zero while the index heritability for the remaining traits
is maximised.
}
\details{
\strong{Projection matrix (Section 7.2):}
\deqn{\mathbf{K} = \mathbf{I}_t -
  \mathbf{P}^{-1}\mathbf{C}\mathbf{U}
  (\mathbf{U}^{\prime}\mathbf{C}\mathbf{P}^{-1}\mathbf{C}\mathbf{U})^{-1}
  \mathbf{U}^{\prime}\mathbf{C}}

\strong{Restricted eigenproblem:}
\deqn{(\mathbf{K}\mathbf{P}^{-1}\mathbf{C} - \lambda_R^2 \mathbf{I}_t)\mathbf{b}_R = 0}

\strong{Selection response and genetic gain:}
\deqn{R_R = k_I \sqrt{\mathbf{b}_R^{\prime}\mathbf{P}\mathbf{b}_R}}
\deqn{\mathbf{E}_R = k_I \frac{\mathbf{C}\mathbf{b}_R}{\sqrt{\mathbf{b}_R^{\prime}\mathbf{P}\mathbf{b}_R}}}

\strong{Implied economic weights:}
\deqn{\mathbf{w}_R = \mathbf{C}^{-1}[\mathbf{P} + \mathbf{Q}_R^{\prime}\mathbf{C}]\mathbf{b}_R}
where \eqn{\mathbf{Q}_R = \mathbf{I} - \mathbf{K}}.
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Restrict traits 1 and 3 to zero genetic gain
result <- resim(pmat, gmat, restricted_traits = c(1, 3))
print(result)
summary(result)
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 7.2.
}
