% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_selection_score.R
\name{predict_selection_score}
\alias{predict_selection_score}
\title{Predict selection index scores}
\usage{
predict_selection_score(index_df, data, genotypes)
}
\arguments{
\item{index_df}{Data frame returned by lpsi()}

\item{data}{Raw phenotypic data matrix/data frame (observations x traits)}

\item{genotypes}{Vector of genotype/treatment labels for each observation}
}
\value{
Data frame of selection index scores by genotype
}
\description{
Predict selection index scores
}
\examples{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
cindex <- lpsi(ncomb = 1, pmat = pmat, gmat = gmat, wmat = weight[, -1], wcol = 1)
predict_selection_score(cindex, data = seldata[, 3:9], genotypes = seldata[, 2])

}
