% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_eigen_indices.R
\name{gw_esim}
\alias{gw_esim}
\title{Genome-Wide Linear Eigen Selection Index Method (GW-ESIM)}
\usage{
gw_esim(pmat, gmat, G_M, M, selection_intensity = 2.063)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).}

\item{G_M}{Covariance between phenotypes and marker scores (n_traits x N_markers).}

\item{M}{Variance-covariance matrix of marker scores (N_markers x N_markers).}

\item{selection_intensity}{Selection intensity constant \eqn{k_I}
(default: 2.063 for 10\% selection).}
}
\value{
Object of class \code{"gw_esim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with key metrics.}
  \item{\code{b_y}}{Coefficients for phenotypic data.}
  \item{\code{b_m}}{Coefficients for marker scores.}
  \item{\code{b_combined}}{Combined coefficient vector.}
  \item{\code{E_W}}{Expected genetic gains per trait.}
  \item{\code{sigma_I}}{Standard deviation of the index.}
  \item{\code{hI2}}{Index heritability (= leading eigenvalue).}
  \item{\code{rHI}}{Accuracy.}
  \item{\code{R_W}}{Selection response.}
  \item{\code{lambda2}}{Leading eigenvalue.}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Implements the GW-ESIM by incorporating genome-wide marker effects directly
into the eigen selection index framework. Uses N marker scores alongside
phenotypic data.
}
\details{
\strong{Eigenproblem (Section 8.3):}
\deqn{(\mathbf{Q}^{-1}\mathbf{X} - \lambda_W^2 \mathbf{I}_{(t+N)})\boldsymbol{\beta}_W = 0}

where:
\deqn{\mathbf{Q} = \begin{bmatrix} \mathbf{P} & \mathbf{G}_M \\ \mathbf{G}_M^{\prime} & \mathbf{M} \end{bmatrix}}
\deqn{\mathbf{X} = \begin{bmatrix} \mathbf{C} & \mathbf{G}_M \\ \mathbf{G}_M^{\prime} & \mathbf{M} \end{bmatrix}}

\strong{Selection response:}
\deqn{R_W = k_I \sqrt{\boldsymbol{\beta}_W^{\prime}\mathbf{Q}\boldsymbol{\beta}_W}}

\strong{Expected genetic gain per trait:}
\deqn{\mathbf{E}_W = k_I \frac{\mathbf{X}\boldsymbol{\beta}_W}{\sqrt{\boldsymbol{\beta}_W^{\prime}\mathbf{Q}\boldsymbol{\beta}_W}}}
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Simulate marker data
N_markers <- 100
n_traits <- nrow(gmat)
G_M <- matrix(rnorm(n_traits * N_markers, sd = 0.5), n_traits, N_markers)
M <- diag(N_markers) + matrix(rnorm(N_markers^2, sd = 0.1), N_markers, N_markers)
M <- (M + t(M)) / 2 # Make symmetric

result <- gw_esim(pmat, gmat, G_M, M)
print(result)
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 8.3.
}
