% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_eigen_indices.R
\name{gesim}
\alias{gesim}
\title{Linear Genomic Eigen Selection Index Method (GESIM)}
\usage{
gesim(pmat, gmat, Gamma, selection_intensity = 2.063)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).}

\item{Gamma}{Covariance between phenotypes and GEBVs (n_traits x n_traits).
This represents Cov(y, gamma) where gamma are GEBVs.}

\item{selection_intensity}{Selection intensity constant \eqn{k_I}
(default: 2.063 for 10\% selection).}
}
\value{
Object of class \code{"gesim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with coefficients and metrics.}
  \item{\code{b_y}}{Coefficients for phenotypic data.}
  \item{\code{b_gamma}}{Coefficients for GEBVs.}
  \item{\code{b_combined}}{Combined coefficient vector.}
  \item{\code{E_G}}{Expected genetic gains per trait.}
  \item{\code{sigma_I}}{Standard deviation of the index.}
  \item{\code{hI2}}{Index heritability (= leading eigenvalue).}
  \item{\code{rHI}}{Accuracy \eqn{r_{HI}}.}
  \item{\code{R_G}}{Selection response.}
  \item{\code{lambda2}}{Leading eigenvalue.}
  \item{\code{implied_w}}{Implied economic weights.}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Implements the GESIM by maximising the squared accuracy through the
generalised eigenproblem combining phenotypic data with GEBVs (Genomic
Estimated Breeding Values). No economic weights are required.
}
\details{
\strong{Eigenproblem (Section 8.2):}
\deqn{(\mathbf{\Phi}^{-1}\mathbf{A} - \lambda_G^2 \mathbf{I}_{2t})\boldsymbol{\beta}_G = 0}

where:
\deqn{\mathbf{\Phi} = \begin{bmatrix} \mathbf{P} & \mathbf{\Gamma} \\ \mathbf{\Gamma} & \mathbf{\Gamma} \end{bmatrix}}
\deqn{\mathbf{A} = \begin{bmatrix} \mathbf{C} & \mathbf{\Gamma} \\ \mathbf{\Gamma} & \mathbf{\Gamma} \end{bmatrix}}

\strong{Implied economic weights:}
\deqn{\mathbf{w}_G = \mathbf{A}^{-1}\mathbf{\Phi}\boldsymbol{\beta}}

\strong{Selection response:}
\deqn{R_G = k_I \sqrt{\boldsymbol{\beta}_G^{\prime}\mathbf{\Phi}\boldsymbol{\beta}_G}}

\strong{Expected genetic gain per trait:}
\deqn{\mathbf{E}_G = k_I \frac{\mathbf{A}\boldsymbol{\beta}_G}{\sqrt{\boldsymbol{\beta}_G^{\prime}\mathbf{\Phi}\boldsymbol{\beta}_G}}}
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Simulate GEBV covariance (in practice, compute from genomic predictions)
Gamma <- gmat * 0.8 # Assume 80\% GEBV-phenotype covariance

result <- gesim(pmat, gmat, Gamma)
print(result)
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 8.2.
}
