# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generic C++ Math Primitives for Experimental Design Statistics
#' @name cpp_math_primitives
#'
#' @description
#' Generic mathematical operations optimized with C++/Eigen.
#' No design-specific logic - purely mathematical primitives that can be
#' orchestrated by R code to implement any experimental design.
#'
#' This architecture allows:
#' - Easy addition of new experimental designs (in R only)
#' - C++ speed for heavy computation
#' - Single source of truth (design_stats.R)
#' - Better maintainability and testability
NULL

#' Compute Grouped Sums for Matrix Columns
#'
#' @description
#' Efficiently computes grouped sums for all columns of a matrix.
#' Equivalent to rowsum() in R but optimized for multiple columns.
#'
#' @param data_mat Numeric matrix (n_obs x n_traits)
#' @param group_idx Integer vector of group indices (1-based, converted to 0-based internally)
#'
#' @return Matrix of grouped sums (n_groups x n_traits)
#'
#' @keywords internal
#' @noRd
cpp_grouped_sums <- function(data_mat, group_idx) {
    .Call(`_selection_index_cpp_grouped_sums`, data_mat, group_idx)
}

#' Compute Multiple Grouped Sums at Once
#'
#' @description
#' Computes grouped sums for multiple grouping variables simultaneously.
#' More efficient than calling cpp_grouped_sums multiple times.
#'
#' @param data_mat Numeric matrix (n_obs x n_traits)
#' @param group_indices List of integer vectors, each representing a grouping variable
#'
#' @return List of matrices, one for each grouping variable
#'
#' @keywords internal
#' @noRd
cpp_multi_grouped_sums <- function(data_mat, group_indices) {
    .Call(`_selection_index_cpp_multi_grouped_sums`, data_mat, group_indices)
}

#' Compute Sum of Products Between Grouped Sums
#'
#' @description
#' Efficiently computes sum of products for grouped sum vectors.
#' Equivalent to crossprod(sums1, sums2) in R.
#'
#' @param sums1 Matrix of grouped sums (n_groups x n_traits)
#' @param sums2 Matrix of grouped sums (n_groups x n_traits)
#' @param divisor Scalar to divide sums by (e.g., n_replications)
#'
#' @return Matrix of sum of products (n_traits x n_traits)
#'
#' @keywords internal
#' @noRd
cpp_crossprod_divided <- function(sums1, sums2, divisor) {
    .Call(`_selection_index_cpp_crossprod_divided`, sums1, sums2, divisor)
}

#' Compute Correction Factor Matrix
#'
#' @description
#' Computes correction factor for all trait pairs.
#' CF[i,j] = (sum_i * sum_j) / n_obs
#'
#' @param data_mat Numeric matrix (n_obs x n_traits)
#'
#' @return Matrix of correction factors (n_traits x n_traits)
#'
#' @keywords internal
#' @noRd
cpp_correction_factor_matrix <- function(data_mat) {
    .Call(`_selection_index_cpp_correction_factor_matrix`, data_mat)
}

#' Compute Grand Means
#'
#' @description
#' Computes mean for each trait (column).
#'
#' @param data_mat Numeric matrix (n_obs x n_traits)
#'
#' @return Vector of grand means (n_traits)
#'
#' @keywords internal
#' @noRd
cpp_grand_means <- function(data_mat) {
    .Call(`_selection_index_cpp_grand_means`, data_mat)
}

#' Compute Trait-wise Min/Max
#'
#' @description
#' Computes minimum and maximum for each trait.
#'
#' @param data_mat Numeric matrix (n_obs x n_traits)
#'
#' @return List with 'min' and 'max' vectors
#'
#' @keywords internal
#' @noRd
cpp_trait_minmax <- function(data_mat) {
    .Call(`_selection_index_cpp_trait_minmax`, data_mat)
}

#' Compute Genotype Means Matrix
#'
#' @description
#' Efficiently computes means for each genotype across all traits.
#' Equivalent to rowsum(data, genotypes) / counts but optimized.
#'
#' @param data_mat Numeric matrix (n_obs x n_traits)
#' @param gen_idx Integer vector of genotype indices (1-based)
#'
#' @return Matrix of genotype means (n_genotypes x n_traits)
#'
#' @keywords internal
#' @noRd
cpp_genotype_means <- function(data_mat, gen_idx) {
    .Call(`_selection_index_cpp_genotype_means`, data_mat, gen_idx)
}

#' Extract Symmetric Submatrix
#'
#' @description
#' Extracts a symmetric submatrix given row/column indices.
#' Used for selecting trait combinations from full covariance matrices.
#'
#' @param mat Numeric matrix (symmetric)
#' @param indices Integer vector of indices (1-based, converted to 0-based internally)
#'
#' @return Symmetric submatrix
#'
#' @keywords internal
#' @noRd
cpp_extract_submatrix <- function(mat, indices) {
    .Call(`_selection_index_cpp_extract_submatrix`, mat, indices)
}

#' Extract Vector Elements
#'
#' @description
#' Extracts specific rows from a column of a matrix.
#' Used for extracting weight vectors for trait combinations.
#'
#' @param mat Numeric matrix
#' @param row_indices Integer vector of row indices (1-based)
#' @param col_index Column index (0-based)
#'
#' @return Vector of extracted elements
#'
#' @keywords internal
#' @noRd
cpp_extract_vector <- function(mat, row_indices, col_index) {
    .Call(`_selection_index_cpp_extract_vector`, mat, row_indices, col_index)
}

#' Solve Symmetric Linear System
#'
#' @description
#' Solves Ax = b for symmetric positive definite matrix A using LDLT decomposition.
#' More efficient than general solve() for symmetric matrices.
#'
#' @param A Symmetric positive definite matrix
#' @param b Right-hand side vector
#'
#' @return Solution vector x
#'
#' @keywords internal
#' @noRd
cpp_symmetric_solve <- function(A, b) {
    .Call(`_selection_index_cpp_symmetric_solve`, A, b)
}

#' Quadratic Form: x' A y
#'
#' @description
#' Computes the quadratic form x' A y efficiently.
#' Equivalent to t(x) %*% A %*% y in R but optimized.
#'
#' @param x First vector
#' @param A Matrix
#' @param y Second vector
#'
#' @return Scalar result of x' A y
#'
#' @keywords internal
#' @noRd
cpp_quadratic_form <- function(x, A, y) {
    .Call(`_selection_index_cpp_quadratic_form`, x, A, y)
}

#' Symmetric Quadratic Form: x' A x
#'
#' @description
#' Computes the symmetric quadratic form x' A x efficiently.
#' Equivalent to t(x) %*% A %*% x in R but optimized.
#'
#' @param x Vector
#' @param A Symmetric matrix
#'
#' @return Scalar result of x' A x
#'
#' @keywords internal
#' @noRd
cpp_quadratic_form_sym <- function(x, A) {
    .Call(`_selection_index_cpp_quadratic_form_sym`, x, A)
}

#' @title Correction Factor Matrix
#'
#' @description
#' Computes the correction factor matrix for ANOVA calculations.
#' CF(i,j) = (sum_i * sum_j) / n
#'
#' @param total_sums Vector of column sums
#' @param n_obs Number of observations
#'
#' @return Symmetric correction factor matrix
#'
#' @keywords internal
#' @noRd
cpp_correction_factor <- function(total_sums, n_obs) {
    .Call(`_selection_index_cpp_correction_factor`, total_sums, n_obs)
}

#' @title Total Sum of Products
#'
#' @description
#' Computes the total sum of products matrix corrected for the mean.
#' TSP(i,j) = sum(x_i * x_j) - CF(i,j)
#'
#' @param data_mat Data matrix (n_obs x n_traits)
#' @param CF Correction factor matrix
#'
#' @return Symmetric sum of products matrix
#'
#' @keywords internal
#' @noRd
cpp_total_sum_of_products <- function(data_mat, CF) {
    .Call(`_selection_index_cpp_total_sum_of_products`, data_mat, CF)
}

#' @title Grouped Sum of Products
#'
#' @description
#' Computes the sum of products for grouped data.
#' GSP(i,j) = sum_g [(sum_i_g * sum_j_g) / n_g] - CF(i,j)
#'
#' @param group_sums Matrix of group sums (n_groups x n_traits)
#' @param group_counts Vector of group sizes
#' @param CF Correction factor matrix
#'
#' @return Symmetric sum of products matrix
#'
#' @keywords internal
#' @noRd
cpp_grouped_sum_of_products <- function(group_sums, group_counts, CF) {
    .Call(`_selection_index_cpp_grouped_sum_of_products`, group_sums, group_counts, CF)
}

#' @title Mean Squares from Sum of Products
#'
#' @description
#' Divides sum of products matrix by degrees of freedom.
#' MS = SP / df
#'
#' @param sum_of_products Sum of products matrix
#' @param df Degrees of freedom
#'
#' @return Mean squares matrix
#'
#' @keywords internal
#' @noRd
cpp_mean_squares <- function(sum_of_products, df) {
    .Call(`_selection_index_cpp_mean_squares`, sum_of_products, df)
}

