% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweetfunctions.R
\name{pred.cascade}
\alias{pred.cascade}
\title{Predict the popularity of information cascade}
\usage{
pred.cascade(
  p.time,
  infectiousness,
  share.time,
  degree,
  n.star = 100,
  features.return = FALSE
)
}
\arguments{
\item{p.time}{equally spaced vector of time to estimate the infectiousness, p.time[1]=0}

\item{infectiousness}{a vector of estimated infectiousness, returned by \code{\link{get.infectiousness}}}

\item{share.time}{observed resharing times, sorted, share.time[1] =0}

\item{degree}{observed node degrees}

\item{n.star}{the average node degree in the social network}

\item{features.return}{if TRUE, returns a matrix of features to be used to further calibrate the prediction}
}
\value{
a vector of predicted populatiry at each time in \code{p.time}.
}
\description{
Predict the popularity of information cascade
}
\examples{
data(tweet)
pred.time <- seq(0, 6 * 60 * 60, by = 60)
infectiousness <- get.infectiousness(tweet[, 1], tweet[, 2], pred.time)
pred <- pred.cascade(pred.time, infectiousness$infectiousness, tweet[, 1], tweet[, 2], n.star = 100)
plot(pred.time, pred)
}
