% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seinfitR.R
\name{seinfitR}
\alias{seinfitR}
\title{SeinfitR}
\usage{
seinfitR(p_i, y, data, start, z_fixed = FALSE, control = seinfitR_control())
}
\arguments{
\item{p_i}{A character string specifying the column name in \code{data} that contains preplant nematode densities.}

\item{y}{A character string specifying the column name in \code{data} that contains the plant growth response.}

\item{data}{A data frame containing the experimental data. It must include at least two columns:
one representing the preplant nematode densities (\code{p_i}) and another representing the plant growth response (\code{y}).}

\item{start}{A list of initial parameter values for \code{m}, \code{t}, and \code{z} (if \code{z_fixed = FALSE}). These values
are used to initialize the nonlinear least squares fitting process.}

\item{z_fixed}{Logical. If \code{TRUE}, the function uses the default value for \( z^t \), as described in
Seinhorst (1986) \doi{10.1007/978-1-4613-2251-1_11}}

\item{control}{A control object created using \code{seinfitR_control()}, which specifies options for the optimization process.}
}
\value{
A list of class \code{"seinfitR"} containing:
\item{fit}{An object of class \code{nls} with the fitted model.}
\item{summary_seinfitR}{Summary statistics of the fitted model.}
\item{cov}{The covariance matrix of parameter estimates (if available).}
\item{data}{The original dataset used for fitting.}
\item{x}{The name of the predictor variable used (\code{p_i}).}
\item{y}{The name of the response variable used (\code{y}).}
\item{z_fixed}{Logical value indicating whether \code{z} was fixed.}
}
\description{
This function fits the Seinhorst equation to experimental data describing the relationship
between preplant nematode densities and plant growth using nonlinear least squares fitting.
The fitting process is performed using the \code{nlsLM} function from the \code{minpack.lm} package.
}
\examples{
# Example: Modeling plant response to nematode densities using "jambu" dataset

# Fit the model using seinfitR with specified initial values
model <- seinfitR(p_i = "p_i", y = "y", data = jambu,
                  start = list(m = 0.103, t = 250, z = 0.991),
                  control = seinfitR_control(maxiter = 5))

# View model summary
summary(model)
}
