% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasdum.R
\name{seasdum}
\alias{seasdum}
\title{F-Test on seasonal dummies}
\usage{
seasdum(x, freq = NA, autoarima = FALSE)
}
\arguments{
\item{x}{time series}

\item{freq}{Frequency of the time series}

\item{autoarima}{Use automatic instead of a (0,1,1) ARIMA model?}
}
\description{
Test for seasonality in a time series based on joint significance seasonal dummies in a non-seasonal ARIMA model.
}
\details{
A RegARIMA model is estimated with (0,1,1)+Seasonal dummies if autoarima=FALSE (default) or (p,d,q)+Seasonal dummies if autoarima=TRUE, (p,d,q) selected by Hyndman-Khandakar algorithm with max(p)=max(q) <= 3. Then the tests checks whether the seasonal dummies are jointly different from zero, i.e. whether deterministic seasonality can be detected in the time series.
}
\examples{
seasdum(ts(rnorm(120, 10,10), frequency=12))
seasdum(ts(rnorm(70, 10,10), frequency=7))
}
\references{
Hyndman, R. J. and Y. Khandakar (2008). Automatic Time Series Forecasting: The forecast Package for R. Journal of Statistical Software 27 (3), 1-22.

Maravall, A. (2011). Seasonality Tests and Automatic Model Identification in TRAMO-SEATS. Bank of Spain.

Ollech, D. and Webel, K. (2020). A random forest-based approach to identifying the most informative seasonality tests. Deutsche Bundesbank's Discussion Paper series 55/2020.
}
\author{
Daniel Ollech
}
