% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tu_tudtc_across_visit.R
\name{check_tu_tudtc_across_visit}
\alias{check_tu_tudtc_across_visit}
\title{Check TU Records where the same date occurs across multiple visits}
\usage{
check_tu_tudtc_across_visit(TU, preproc = identity, ...)
}
\arguments{
\item{TU}{Tumor Identification SDTM dataset with variables USUBJID, TUDTC, VISIT,
TUEVAL (optional), TUTESTCD (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed.
}
\description{
This check identifies records where the same date TUDTC occurs
across multiple visits. Only applies to assessments by investigator,
selected based on uppercased TUEVAL = "INVESTIGATOR" or missing or
TUEVAL variable does not exist.
}
\examples{

# records flagged 
TU <- data.frame(USUBJID = 1,
                 TUDTC = c(rep("2016-01-01",3), rep("2016-06-01",5), rep("2016-06-24",2)),
                 VISIT = c(rep("C1D1",3), rep("C1D2",3), rep("C2D1",4)),
                 TUSPID = "FORMNAME-R:13/L:13XXXX",
                 stringsAsFactors=FALSE)

check_tu_tudtc_across_visit(TU)
check_tu_tudtc_across_visit(TU, preproc=roche_derive_rave_row)

# no records flagged because non-Investigator results
TU2 <- TU
TU2$TUEVAL <- "INDEPENDENT ASSESSOR"

check_tu_tudtc_across_visit(TU2)
check_tu_tudtc_across_visit(TU2, preproc=roche_derive_rave_row)

# example with TUTESTCD and with records flagged
TU3 <- TU
TU3$TUTESTCD = c(rep("TUMIDENT", 2), rep("OTHER", 2), 
   rep("TUMIDENT", 2), rep("OTHER", 2), rep("TUMIDENT", 2))
check_tu_tudtc_across_visit(TU3)
check_tu_tudtc_across_visit(TU3, preproc=roche_derive_rave_row)


# example without TUSPID and with records flagged
TU4 <- TU
TU4$TUSPID <- NULL

check_tu_tudtc_across_visit(TU4)
check_tu_tudtc_across_visit(TU4, preproc=roche_derive_rave_row)

# example with required variable missing
TU5 <- TU
TU5$VISIT <- NULL

check_tu_tudtc_across_visit(TU5)
check_tu_tudtc_across_visit(TU5, preproc=roche_derive_rave_row)

}
\author{
Will Harris
}
