% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rs_rsdtc_visit.R
\name{check_rs_rsdtc_visit}
\alias{check_rs_rsdtc_visit}
\title{Check missing RSDTC and VISIT}
\usage{
check_rs_rsdtc_visit(RS)
}
\arguments{
\item{RS}{Disease Response SDTM dataset with variables USUBJID, RSDTC,
RSORRES, VISIT, RSSTAT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing RSDTC or VISIT values when
RSORRES is not missing and RSSTAT not equal to "NOT DONE" in RS dataset
and returns a data frame. Only applies to assessments by investigator.
}
\examples{

RS <- data.frame(
USUBJID = 1:10,
RSDTC = 1:10,
RSORRES = "THING",
VISIT = "C1D1",
RSSTAT = 1:10,
RSEVAL = c("NA","","IRF","investigator",rep("INVESTIGATOR",6)),
stringsAsFactors=FALSE
)

RS$RSDTC[1]=""
RS$RSDTC[2]="NA"
RS$RSDTC[3]=NA
RS$VISIT[3]=""
RS$VISIT[4]="NA"
RS$VISIT[5]=NA
check_rs_rsdtc_visit(RS)

RS$RSORRES[1]=""
check_rs_rsdtc_visit(RS)

RS$RSORRES[4] = "THING 1"
RS$RSORRES[5] = "THING 2"

check_rs_rsdtc_visit(RS)


}
\author{
Peggy Wen, Stella Banjo (HackR 2021)
}
