% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_lbstresu.R
\name{check_lb_lbstresu}
\alias{check_lb_lbstresu}
\title{Check for missing lab units (LBSTRESU)}
\usage{
check_lb_lbstresu(LB, preproc = identity, ...)
}
\arguments{
\item{LB}{Lab SDTM dataset with variables USUBJID, LBSTRESC, LBSTRESN,
LBORRES, LBSTRESU, LBTESTCD, LBDTC, LBMETHOD (optional),
LBSPID (optional), and VISIT (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies records where original lab values (LBORRES)
exist but standard lab units (LBSTRESU) are not populated, excluding
qualitative results (LBMETHOD) and excluding records when LBTESTCD in
("PH" "SPGRAV")
}
\examples{

LB <- data.frame(
USUBJID = 1:10,
LBSTRESC = "5",
LBSTRESN = 1:10,
LBORRES = "5",
LBSTRESU = "g/L",
LBTESTCD = "ALB",
LBDTC = 1:10,
stringsAsFactors=FALSE
)

check_lb_lbstresu(LB)

LB$LBSTRESU[1]=""
check_lb_lbstresu(LB)

LB$LBSTRESU[2]="NA"
check_lb_lbstresu(LB)

LB$LBSTRESU[3]=NA
check_lb_lbstresu(LB)

LB$LBSPID= "FORMNAME-R:2/L:2XXXX"
check_lb_lbstresu(LB,preproc=roche_derive_rave_row)

LB$VISIT= "SCREENING"
check_lb_lbstresu(LB)

LB$LBSTRESU=NULL
check_lb_lbstresu(LB)

}
\author{
Iris Zhao
}
