% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exstdtc_after_exendtc.R
\name{check_ex_exstdtc_after_exendtc}
\alias{check_ex_exstdtc_after_exendtc}
\title{Check that all exposure start dates are on or before exposure end dates}
\usage{
check_ex_exstdtc_after_exendtc(EX)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID,EXTRT,EXSTDTC,EXENDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies EXSTDTC values that are after EXENDTC values
}
\examples{

EX <- data.frame(
 STUDYID = 1,
 USUBJID = 1:12,
 EXTRT = "SOME DRUG",
 EXSTDTC = c("2017-01-01","2017-01-03","2017-01-01T14:26","2017","2017-02","2017"      ,""    ,
             "2017"   ,"2017-01-01T14:26","2017-01-01T14:26","2017-01-01T14","2017-01-01T14:26:02")
             ,
 EXENDTC = c("2017-01-01","2017-01-02","2017-01-01T14:25","2015","2017-01","2016-01-01","2000",
             "2017-02","2017-01-01"      ,"2017-01","2017-01-01T13","2017-01-01T14:26:01")
             ,
 EXOCCUR = "Y",
 VISIT = "CYCLE 1 DAY 1",
 stringsAsFactors=FALSE
)

check_ex_exstdtc_after_exendtc(EX)

EX$EXOCCUR <- NULL
EX$VISIT <- NULL
check_ex_exstdtc_after_exendtc(EX)

EX$EXTRT <- NULL
check_ex_exstdtc_after_exendtc(EX)

}
\author{
Sara Bodach
}
