% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disclosure_risk.R
\name{disclosure_risk}
\alias{disclosure_risk}
\title{Calculate disclosure risk for raster cells}
\usage{
disclosure_risk(x, risk_type = x$risk_type)
}
\arguments{
\item{x}{\code{\link{sdc_raster}} object.}

\item{risk_type}{\code{character}: "external", "internal", "discrete".}
}
\value{
\link[raster:raster]{raster::raster} object with the disclosure risk.
}
\description{
The disclosure risk function is used by \code{\link[=is_sensitive]{is_sensitive()}} to determine the risk of
a \code{raster} cell. It returns a score between 0 and 1 for cells that have a finite
value (otherwise \code{NA}).
}
\details{
Different risk functions include:
\itemize{
\item external (numeric variable), calculates how much the largest value
comprises the total sum within a cell
\item internal (numeric variable), calculates how much the largest value
comprises the sum without the second largest value
\item discrete (logical variable), calculates the fraction of \code{TRUE} vs \code{FALSE}
}
}
\seealso{
Other sensitive: 
\code{\link{is_sensitive}()},
\code{\link{is_sensitive_at}()},
\code{\link{plot_sensitive}()},
\code{\link{remove_sensitive}()},
\code{\link{sdc_raster}()},
\code{\link{sensitivity_score}()}
}
\concept{sensitive}
