% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mode.R
\name{sample_mode}
\alias{sample_mode}
\title{Compute a sample mode}
\usage{
sample_mode(x)
}
\arguments{
\item{x}{Numeric vector}
}
\value{
A single numeric value equal to the sample mode
}
\description{
\code{sample_mode} computes the sample mode, i.e. the value in \code{x} with the highest frequency of occurrence. If there are multiple modes, the mode that occurs first in \code{x} is returned, with a warning that lists the other modes found.
}
\examples{
data(anchoring)
sample_mode(anchoring$everest_feet)
# Multiple modes give a warning:
sample_mode(c(3,3,3,1,1,1,2,2,2))
}
