% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherit_scplot.R
\name{.inherit_scplot}
\alias{.inherit_scplot}
\title{Inherit parameter descriptions for scplot objects}
\usage{
.inherit_scplot(
  object,
  label,
  labels,
  color,
  size,
  linewidth,
  hjust,
  vjust,
  angle,
  width,
  face,
  linetype,
  shape,
  text,
  background,
  case,
  variable,
  point,
  line,
  ...
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{label}{A Character vector with text labels.}

\item{labels}{A Character vector with text labels.}

\item{color}{A character string or a number defining the color of an element.}

\item{size}{Text size relative to the base text size.}

\item{linewidth}{A number with the width of the line.}

\item{hjust}{Horizontal justification (in [0,1])}

\item{vjust}{Vertical justification (in [0,1])}

\item{angle}{Angle (in [0,360])}

\item{width}{Line width.}

\item{face}{Font face (\verb{"plain", "italic", "bold", "bold.italic"})}

\item{linetype}{A character string with the line type: \verb{"solid", "dashed", "dotted"}}

\item{shape}{Number. See \code{pch} graphical parameter on \code{par} help page
\code{\link[=par]{par()}}.}

\item{text}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}

\item{background}{A list with background styling arguments (fill, color,
size, linetype).}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{variable}{Name of the dataline variable to apply the style.}

\item{point}{A list with point parameters (\verb{"colour", "size", "shape"}). See
\code{\link[=element_point]{element_point()}}.}

\item{line}{List with line parameters (\verb{"colour", "linewidth", "linetype", "lineend", "arrow"}). See \code{\link[=element_line]{element_line()}}.}

\item{...}{Further styling arguments: color, size, face, family, hjust,
vjust, lineheight, angle, linetype, lineend, arrow, fill, margin.}
}
\value{
No return value.
}
\description{
This is a dummy function that is not meant to be called directly. It is used
to inherit parameter descriptions in other functions related to \code{scplot}
objects.
}
\keyword{internal}
