% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_line.R
\name{add_line}
\alias{add_line}
\title{Add line to an scplot object}
\usage{
add_line(
  object,
  case = 1,
  x0 = NULL,
  y0 = NULL,
  x1 = NULL,
  y1 = NULL,
  hline = NULL,
  vline = NULL,
  color = "black",
  linewidth = 0.7,
  linetype = "solid"
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{x0}{Origin x position of the line.}

\item{y0}{Origin y position of the line.}

\item{x1}{End x position of the line.}

\item{y1}{End y position of the line.}

\item{hline}{y position of horizontal line.}

\item{vline}{x position of vertical line.}

\item{color}{A character string or a number defining the color of an element.}

\item{linewidth}{A number with the width of the line.}

\item{linetype}{A character string with the line type: \verb{"solid", "dashed", "dotted"}}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with added element
\code{lines}.
}
\description{
Draws a line on the scplot. Either a horizontal line (hline),
vertical line (vline), or a line defined by its start (x0, y0)
and end (x1, y1) points can be drawn.
}
\examples{
data(exampleAB, package = "scan")
p1 <- scplot(exampleAB$Anja)  |>
  add_line(hline = 70, color = "darkred") |>
  add_line(vline = 3, color = "blue") |>
  add_line(x0 = 1, y0 = 70, x1 = 4, y1 = 80, color = "green")
}
