% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scplot_rand.R
\name{scplot_rand}
\alias{scplot_rand}
\title{Random start position plot
Plot of statistics for random phase B start positions}
\usage{
scplot_rand(
  scdf,
  statistic = "Mean B-A",
  x_label = "Start phase B",
  color_label = "Compared to\\nobserved",
  colors = c(Above = "coral3", Below = "aquamarine4", Observed = "#56B4E9", Equal =
    "black"),
  ...
)
}
\arguments{
\item{scdf}{A single-case data frame object.}

\item{statistic}{A string with a the name of a statistic.
Defaults to \verb{Mean B-A}. See rand_test() function for all options.}

\item{x_label}{Character string with the x label.}

\item{color_label}{Character string with the color label.}

\item{colors}{Named vector with color codes.}

\item{...}{further arguments passted to the scan \code{rand_test()} function.}
}
\description{
Random start position plot
Plot of statistics for random phase B start positions
}
\examples{
scplot_rand(scan::byHeart2011[1:5])

}
