% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scperturbr.R
\name{etest}
\alias{etest}
\title{etest}
\usage{
etest(
  seurat_object,
  groupby = "perturbation",
  control = "control",
  reduction = "pca",
  verbose = TRUE,
  permutations = 1000
)
}
\arguments{
\item{seurat_object}{An object of class Seurat.}

\item{groupby}{An object of class character. Points to the column in the
Seurat object's meta data that contains the group labels.}

\item{control}{An object of class character. The group that is used as the
control.}

\item{reduction}{An object of class character. The reduction / embedding in
seurat_object that is used to compute the E-distance in.}

\item{verbose}{An object of class logical. If TRUE, prints messages.
Default is TRUE.}

\item{permutations}{An object of class integer. The number of permutations
used to compute the p-value. Default is 1000.}
}
\value{
Returns an object of class data.frame. For each group contains the
    E-test p-value and the E-distance to control group.
}
\description{
Performs E-testing on a Seurat object.
    Computes E-test statistics for each group in a Seurat object,
    using the E-distance in space given by reduction to the group defined
    by control.
}
\examples{
    # Add some code illustrating how to use the function
}
