% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovMat_03.R
\name{CovMat_03}
\alias{CovMat_03}
\title{Computes the correlation matrix corresponding to the SCE model}
\usage{
CovMat_03(
  parm,
  matList,
  adj_positions,
  combined_effects = FALSE,
  interaction_effects = list()
)
}
\arguments{
\item{parm}{the parameter}

\item{matList}{a list of the matrices (pairwise+spatial)}

\item{adj_positions}{position of the spatial effect (if embedded)}

\item{combined_effects}{if yes, computes the Fosdick-Raftery model}

\item{interaction_effects}{lists the interaction effects}
}
\value{
a named list including the following elements:
           Phi:                sum of scaled pairwise effect matrices
           Gamma:              the null-matrix (no longer used)
           matList_combined    list of all matrices
                               (pairwise+spatial+interaction)
           Sigma               the SCE-model correlation matrix
           alpha_delta         linear effects (pairwise+spatial)

the correlation matrix corresponding to the SCE model
}
\description{
Computes the correlation matrix corresponding to the SCE model
}
\keyword{internal}
