% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-ordinal.R
\name{get_metrics.forecast_ordinal}
\alias{get_metrics.forecast_ordinal}
\title{Get default metrics for nominal forecasts}
\usage{
\method{get_metrics}{forecast_ordinal}(x, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{A forecast object (a validated data.table with predicted and
observed values, see \code{\link[=as_forecast_binary]{as_forecast_binary()}}).}

\item{select}{A character vector of scoring rules to select from the list. If
\code{select} is \code{NULL} (the default), all possible scoring rules are returned.}

\item{exclude}{A character vector of scoring rules to exclude from the list.
If \code{select} is not \code{NULL}, this argument is ignored.}

\item{...}{unused}
}
\description{
For ordinal forecasts, the default scoring rules are:
\itemize{
\item "log_score" = \code{\link[=logs_categorical]{logs_categorical()}}
\item "rps" = \code{\link[=rps_ordinal]{rps_ordinal()}}
}
}
\examples{
get_metrics(example_ordinal)
}
\seealso{
Other get_metrics functions: 
\code{\link{get_metrics}()},
\code{\link{get_metrics.forecast_binary}()},
\code{\link{get_metrics.forecast_nominal}()},
\code{\link{get_metrics.forecast_point}()},
\code{\link{get_metrics.forecast_quantile}()},
\code{\link{get_metrics.forecast_sample}()},
\code{\link{get_metrics.scores}()}
}
\concept{get_metrics functions}
\keyword{handle-metrics}
