% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_groupplot.R
\name{gg_groupplot}
\alias{gg_groupplot}
\title{Create ggplot to display group differences (box+point+hist)}
\usage{
gg_groupplot(data, x, y, meanline = TRUE)
}
\arguments{
\item{data}{The input dataset.}

\item{x}{The grouping factor, e.g. Sex}

\item{y}{The numeric outcome variable, e.g. Age}

\item{meanline}{Optional indicator of means}
}
\value{
Output group plot
}
\description{
The \code{gg_groupplot} function can be used to create group
difference plots for scientific publication.
This is intended to summarize a continuous outcome (\code{y})
based on a factor ('x') from an input dataset (\code{data}).
The plot will include standard ggplot2::geom_boxplot
indicating 25th, median, and 75th percentile for the box
and 1.5 * IQR for the whiskers. Outliers are not
highlighted.
Raw data is displayed with standard ggplot2::geom_point
and lateral but not vertical jittering.
Histograms are shown with half_violin
to the right of each boxplot.
If meanline = = TRUE (default), gray dots will indicate
the mean for each variable (vs. median in boxplot)
connected by a gray line.
This function will drop any NA values.
Requires \code{ggplot2} and \code{ggdist} libraries.
}
\examples{
gg_groupplot(data = psydat, x = Sex, y = depressT, meanline = TRUE)

}
