% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.sbm.r
\name{predict.sbm}
\alias{predict.sbm}
\title{Predict estimates}
\usage{
\method{predict}{sbm}(object, newdata = NULL, reps = 999, ...)
}
\arguments{
\item{object}{A size biased model fit of class \code{\link{sbm}}.}

\item{newdata}{A dataframe of covariate values with fields matching
covariates used in \code{object}.}

\item{reps}{Integer giving the number of random draws for variance estimation.}

\item{...}{Additional arguments (unused).}
}
\value{
A dataframe of predictions with fields \code{est} (estimated average),
 \code{se} (estimated standard error), and \code{lcl}, \code{ucl} (lower and
 upper 95 percent confidence limits).
}
\description{
Generates predicted underlying averages from a size biased model,
given a set of covariates if these are used in the model.
}
\details{
When \code{newdata} is missing, \code{make_table} is used to
 generate a dataframe of covariates at which to predict, based on the
 model formula and covariate data.
}
\examples{
  data(BCI_speed_data)
  agoutiData <- subset(BCI_speed_data, species=="agouti")
  lmod_mass <- sbm(speed~mass, agoutiData, pdf="lnorm")
  nd <- data.frame(mass = c(1, 10, 100))
  predict(lmod_mass, nd)
}
