% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prev.R
\name{sat_untarzip}
\alias{sat_untarzip}
\title{Unzip compressed files in tar or zip format}
\usage{
sat_untarzip(
  file,
  out_dir = NULL,
  include_filename = NULL,
  only_show_files = FALSE
)
}
\arguments{
\item{file}{A string or string vector.}

\item{out_dir}{A string or string vector, output folder.}

\item{include_filename}{A boolean, include file name as a folder in the output.}

\item{only_show_files}{A boolean, only show the files that would be unzipped,
and the destination folders, not unzip them.}
}
\value{
A vector of strings, name of the processed files.
}
\description{
Given a vector of compressed file names or the name of a folder containing
compressed files, unzip the files to the given output folder. If no output
folder is indicated, it is considered the same folder where the input files
are.
}
\details{
We can indicate whether to include the file name (without the extension) as a
folder in the output folder.
}
\examples{

f <- system.file("extdata", package = "satres")
r <- sat_untarzip(f, only_show_files = TRUE)

f1 <- system.file("extdata", "satres.zip", package = "satres")
f2 <- system.file("extdata", "satres.tar", package = "satres")
r <- sat_untarzip(c(f1, f2), only_show_files = TRUE)

}
\seealso{
\code{\link{satres}}
}
\concept{satellite previous functions}
