% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oq.R
\name{run_oq}
\alias{run_oq}
\title{Generates an Operational Qualification Report}
\usage{
run_oq(location)
}
\arguments{
\item{location}{The path to the desired output directory.  The IQ
reports and any other associated files will be placed in this directory.
Location should be specified as a directory only.  The file names
will be generated by the function.}
}
\value{
The path to the output directory.  This directory will
contain subdirectories with the output reports, logs, and other files
produced by the Operation Qualification.  At the top level, the directory
will contain a PDF report showing a summary of the results of the OQ. After
the function is run, review this report to ensure that all tests passed.
}
\description{
The \code{run_oq} function executes an
operational qualification (OQ)
on the currently installed \strong{sassy} packages and generates a report
on the results.  The OQ ensures that the \strong{sassy} packages are
installed and working
as expected.  The results will be placed in the supplied location.
}
\details{
The Operation Qualification works by executing a representative set of
functions from each \strong{sassy} package, and comparing the
results against expected values.  Here is a brief description of the
operations performed on each package:
\itemize{
\item{\strong{logr}: A sample log is produced and checked for existence.
This test confirms the following functions: \code{log_open}, \code{log_print},
and \code{log_close}.
}
\item{\strong{fmtr}: The basic operations of the package are executed
and compared against expected output: \code{fapply}, \code{fdata},
\code{value}, \code{condition}, \code{write.fcat}, and \code{read.fcat}.
}
\item{\strong{libr}: The procedure verifies that the fundamental operations
of the package are working properly without errors: \code{libname},
\code{lib_add}, \code{lib_remove}, \code{dictionary}, and \code{datastep}.
}
\item{\strong{reporter}: The reporter package is tested by producing
sample reports in each of the available output types: TXT, HTML,
RTF, PDF, and DOCX.  This method tests almost all of the sub-functions
of the package.
}
\item{\strong{common}: The following representative functions are
run and tested for errors and valid return values: \code{v},
\code{sort}, \code{labels},
\code{roundup}, \code{Sys.path}, \code{find.names},
and \code{copy.attributes}.
}
\item{\strong{procs}: All the major functions of the package are
executed and tested against expected results: \code{proc_freq},
\code{proc_means}, \code{proc_reg}, \code{proc_transpose},
\code{proc_sort}, and \code{proc_print}.
}
}
}
\examples{
# Create a temp directory
tmp <- tempdir()

# Uncomment to Run the Operational Qualification
# run_oq(tmp)
}
