% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to-r.R
\name{sas_to_r}
\alias{sas_to_r}
\title{Convert SAS table to R}
\usage{
sas_to_r(table_name, libref = "WORK")
}
\arguments{
\item{table_name}{string; Name of table in SAS.}

\item{libref}{string; Name of libref SAS table is stored within.}
}
\value{
\code{data.frame} of the specified SAS table.
}
\description{
Converts table from current SAS session into a R \code{data.frame}.
}
\details{
SAS only has two data types (numeric and character). Data types are converted
as follows:
\itemize{
\item numeric -> double
\item character -> character
\item numeric (datetime, timezones are lost) -> POSIXct
\item numeric (date) -> POSIXct
}

In the conversion process dates and datetimes are converted to local
time. If utilizing another timezone, use \verb{attr(date, "tzone") <-} or
\code{lubridate::with_tz()} to convert back to the desired time zone.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
sas_connect()

cars <- sas_to_r("cars", "sashelp")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sas_from_r]{sas_from_r()}}
}
