% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{sas_engine}
\alias{sas_engine}
\title{A SAS engine for \code{knitr}}
\usage{
sas_engine(options)
}
\arguments{
\item{options}{Options from \code{knitr}.}
}
\value{
\code{knitr} engine output.
}
\description{
Produces HTML or latex output for rending within quarto or rmarkdown documents.
}
\details{
Will be activated by running \code{library(sasquatch)}
\subsection{Supported \code{knitr} chunk options}{

\code{sasquatch}'s engine implements may of the same options as the R engine in
\code{knitr}, but not all.
\itemize{
\item \code{eval} (Default: \code{TRUE}): Evaluate the code chunk (if false, just echos the
code into the output)
\item \code{echo} (Default: \code{TRUE}): Include the source code in output
\item \code{output} (Default: \code{TRUE}): Include the results of executing the code in
the output (\code{TRUE} or \code{FALSE}).
\item \code{include} (Default: \code{TRUE}): Include any output (code or results).
\item \code{capture} (Only within HTML; Default: \code{"both"}): If \code{"both"}, tabpanel with output and log
included. If \code{"listing"}, only output is included. If \code{"log"} only log is included.
\item \code{out.width} (Only within HTML; Default: \code{"auto"}): Width of output.
\item \code{out.height} (Only within HTML; Default: \code{"auto"}): Height of output.
}
}
}
\examples{
# The below function is run internally within `sasquatch` on startup
knitr::knit_engines$set(sas = sas_engine)
}
