% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{sas_connect}
\alias{sas_connect}
\title{Establish SAS session}
\usage{
sas_connect(cfgname, reconnect = FALSE)
}
\arguments{
\item{cfgname}{string; Name of configuration to use from the SAS_config_names
list within in \code{sascfg_personal.py}.}

\item{reconnect}{logical; Establish a new connection if a connection already
exists?}
}
\value{
No return value.
}
\description{
Starts a SAS session. This is required before doing anything!
}
\details{
All configurations are specified within the \code{sascfg_personal.py} file inside
the \code{SASPy} package. For more information about \code{SASPy} configuration, check
out the \href{https://sassoftware.github.io/saspy/configuration.html}{configuration documentation}
or \code{vignette("configuration")}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
sas_connect(cfgname = "oda")
\dontshow{\}) # examplesIf}
}
\seealso{
Other session management functions: 
\code{\link{sas_disconnect}()},
\code{\link{sas_get_session}()}
}
\concept{session management functions}
