% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{exactly}
\alias{exactly}
\title{Define singleton intervals explicitly}
\usage{
exactly(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
The same as \code{rep(x, each = 2)}.
}
\description{
\code{exactly()} duplicates its input.
It lets you define singleton intervals like this: \code{chop(x, c(1, exactly(2), 3))}.
This is the same as \code{chop(x, c(1, 2, 2, 3))} but conveys your intent more
clearly.
}
\examples{
chop(1:10, c(2, exactly(5), 8))

# same:
chop(1:10, c(2, 5, 5, 8))
}
