% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{sc_cols_positive}
\alias{sc_cols_positive}
\title{Checks that all elements from the specified columns are positive}
\usage{
sc_cols_positive(object, cols, zero_feasible = TRUE, ...)
}
\arguments{
\item{object}{table with a columns specified by \code{cols}}

\item{cols}{vector of characters of columns that are checked against the
specified range}

\item{zero_feasible}{if zero is in the range or not}

\item{...}{further parameters that are passed to \link{add_sanity_check}.}
}
\value{
list of logical vectors where TRUE indicates where the check failed.
  Every list entry represents one of the columns specified in cols.
  This might be helpful if one wants to apply a counter-measure.
}
\description{
Checks that all elements from the specified columns are positive
}
\examples{
d <- data.frame(a = c(0, 0.2, 3, Inf), b = c(1:4))
dummy_call <- function(x) {
  sc_cols_positive(d, cols = c("a", "b"), zero_feasible = FALSE,
    description = "Measurements are expected to be positive")
}
dummy_call(x = d)
get_sanity_checks()
}
