% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_sanity_checks}
\alias{get_sanity_checks}
\title{Returns all performed sanity checks}
\usage{
get_sanity_checks()
}
\value{
all sanity checks, i.e. a data.table with the following column
\describe{
  \item{description}{character that was provided by the user through the
    parameter \code{description}}
  \item{additional_desc}{character that provides additional information
    about the check that was generated by the convenience functions}
  \item{data_name}{name of the data set that passed to the function that
    performed the sanity check. This can also be specified by the user}
  \item{n}{a logical vector is the basis of all sanity checks. This is
    length of the logical vector that was used, which in general is the
    number of rows of the table that was checked}
  \item{n_fail}{how often the logical vector was TRUE}
  \item{n_na}{how often the logical vector was NA}
  \item{counter_meas}{character provided by the user about how a fail will
    be addressed. Note that this never happens inside a function of
    \code{sanityTracker} but is realized by the user after the check was
    performed. It is only for documentation when the results of the checks
    are displayed.}
  \item{fail_vec_str}{this captures how the actual logical vector of fails
    was build}
  \item{param_name}{usually generated by the convenience functions and it
    also may be a composition of more than one parameter name. However this
    parameter could also have been provided by the user}
  \item{call}{character of the call where the sanity check happend}
  \item{example}{if a check failed and the table is available,
    then some examples of rows that lead to the fail are stored here}
}
}
\description{
Returns all performed sanity checks
}
\seealso{
\link{add_sanity_check}
}
