% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmProcess.R
\name{hmmProcess}
\alias{hmmProcess}
\title{hmmProcess calculates the probability distribution of a random process
following a Markov chain}
\usage{
hmmProcess(prior, trans_mat, n)
}
\arguments{
\item{prior}{Numeric vector or a one row matrix of length K representing the
prior probabilities of the Markov chain.}

\item{trans_mat}{Matrix of size \eqn{(K, K)} representing the transition
matrix of the Markov chain.}

\item{n}{Numeric. Number of variables of the Markov chain.}
}
\value{
Matrix of size \eqn{(n, K)} giving the distribution of process given
the K-state Markov chain parameters.
}
\description{
hmmProcess calculates the probability distribution of a random process
following a Markov chain
}
\details{
hmmProcess calculates the distribution
\eqn{P(Z_{1},\dots,Z_{n};\pi,A)} of a Markov chain
\eqn{(Z_{1},\dots,Z_{n})} with prior probability \eqn{\pi} and transition
matrix \eqn{A}.

The calculation is based on the following formula:

\eqn{P(Z_{i} = k) = \sum_{l} P(Z_{i} = k, Z_{i-1} = l) = \sum_{l} P(Z_{i} =
  k | Z_{i-1} = l) \times P(Z_{i-1} = l) = \sum_{l} A_{lk} \times
  P(Z_{i-1})}{P(Z_{i} = k) = \sum_{l} P(Z_{i} = k, Z_{i-1} = l) = \sum_{l}
  P(Z_{i} = k | Z_{i-1} = l) x P(Z_{i-1} = l) = \sum_{l} A_{lk} x P(Z_{i-1})}
}
