% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emMHMMR.R
\name{emMHMMR}
\alias{emMHMMR}
\title{emMHMMR implemens the EM (Baum-Welch) algorithm to fit a MHMMR model.}
\usage{
emMHMMR(X, Y, K, p = 3, variance_type = c("heteroskedastic",
  "homoskedastic"), n_tries = 1, max_iter = 1500, threshold = 1e-06,
  verbose = FALSE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Matrix of size \eqn{(m, d)} representing a \eqn{d} dimension time
series observed at points \eqn{1,\dots,m}.}

\item{K}{The number of regimes (MHMMR components).}

\item{p}{Optional. The order of the polynomial regression. By default, \code{p} is
set at 3.}

\item{variance_type}{Optional character indicating if the model is
"homoskedastic" or "heteroskedastic". By default the model is
"heteroskedastic".}

\item{n_tries}{Optional. Number of runs of the EM algorithm. The solution
providing the highest log-likelihood will be returned.

If \code{n_tries} > 1, then for the first run, parameters are initialized by
uniformly segmenting the data into K segments, and for the next runs,
parameters are initialized by randomly segmenting the data into K
contiguous segments.}

\item{max_iter}{Optional. The maximum number of iterations for the EM
algorithm.}

\item{threshold}{Optional. A numeric value specifying the threshold for the
relative difference of log-likelihood between two steps of the EM as
stopping criteria.}

\item{verbose}{Optional. A logical value indicating whether or not values of
the log-likelihood should be printed during EM iterations.}
}
\value{
EM returns an object of class \link{ModelMHMMR}.
}
\description{
emMHMMR implements the maximum-likelihood parameter estimation of the MHMMR
model by the Expectation-Maximization (EM) algorithm, known as Baum-Welch
algorithm in the context of HMMs.
}
\details{
emMHMMR function implements the EM algorithm. This function starts
with an initialization of the parameters done by the method \code{initParam} of
the class \link{ParamMHMMR}, then it alternates between the E-Step
(method of the class \link{StatMHMMR}) and the M-Step (method of the
class \link{ParamMHMMR}) until convergence (until the relative
variation of log-likelihood between two steps of the EM algorithm is less
than the \code{threshold} parameter).
}
\examples{
data(multivtoydataset)

mhmmr <- emMHMMR(multivtoydataset$x, multivtoydataset[,c("y1", "y2", "y3")],
                 K = 5, p = 1, verbose = TRUE)

mhmmr$summary()

mhmmr$plot()
}
\seealso{
\link{ModelMHMMR}, \link{ParamMHMMR}, \link{StatMHMMR}
}
