% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salt_substitute.R
\name{salt_substitute}
\alias{salt_substitute}
\title{Substitute certain characters in a vector}
\usage{
salt_substitute(x, substitutions, p = 0.2, n = 1)
}
\arguments{
\item{x}{A vector. This will always be coerced to character during salting.}

\item{substitutions}{Values to be substituted in}

\item{p}{A number between 0 and 1. Percent of values in \code{x} that should be
salted.}

\item{n}{A positive integer. Number of times to add new values from
\code{insertions} into selected values in \code{x} manually supply your own list of
characters.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Substitute certain characters in a vector
}
\examples{
x <- c("Lorem ipsum dolor sit amet, consectetur adipiscing elit.",
       "Nunc finibus tortor a elit eleifend interdum.",
       "Maecenas aliquam augue sit amet ultricies placerat.")

salt_substitute(x, shaker$digits, p = 0.5, n = 5)
}
