% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_update_report}
\alias{sf_update_report}
\title{Update a report}
\usage{
sf_update_report(report_id, report_metadata, verbose = FALSE)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{report_metadata}{\code{list}; a list representing the properties to create
the report with. The names of the list must be one or more of the 3 accepted
metadata properties: \code{reportMetadata}, \code{reportTypeMetadata},
\code{reportExtendedMetadata}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list} representing the newly cloned report with up to 4 properties
that describe the report:
\describe{
\item{attributes}{Report type along with the URL to retrieve common objects and
joined metadata.}
\item{reportMetadata}{Unique identifiers for groupings and summaries.}
\item{reportTypeMetadata}{Fields in each section of a report type plus filter information for those fields.}
\item{reportExtendedMetadata}{Additional information about summaries and groupings.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Save changes to a report by sending a PATCH request to the Report resource.
Note that saving a report deletes any running async report jobs because they
might be obsolete based on the updates.
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_save_report.htm#example_save_report}{Example}
}
}

\examples{
\dontrun{
# first, grab all possible reports in your Org
all_reports <- sf_query("SELECT Id, Name FROM Report")

# second, get the id of the report to update
this_report_id <- all_reports$Id[1]

my_updated_report <- sf_update_report(this_report_id,
                                      report_metadata =
                                        list(reportMetadata =
                                          list(name = "Updated Report Name!")))

# alternatively, pull down its metadata and update the name
report_details <- sf_describe_report(this_report_id)
report_details$reportMetadata$name <- paste0(report_details$reportMetadata$name,
                                             " - UPDATED")

# fourth, update the report by passing the metadata
my_updated_report <- sf_update_report(this_report_id,
                                      report_metadata = report_details)
}
}
\seealso{
Other Report functions: 
\code{\link{sf_copy_report}()},
\code{\link{sf_create_report}()},
\code{\link{sf_delete_report}()},
\code{\link{sf_describe_report}()},
\code{\link{sf_describe_report_type}()},
\code{\link{sf_execute_report}()},
\code{\link{sf_list_report_fields}()},
\code{\link{sf_list_report_filter_operators}()},
\code{\link{sf_list_report_types}()},
\code{\link{sf_list_reports}()},
\code{\link{sf_query_report}()},
\code{\link{sf_run_report}()}
}
\concept{Report functions}
