% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{sf_create}
\alias{sf_create}
\title{Create Records}
\usage{
sf_create(
  input_data,
  object_name,
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  guess_types = TRUE,
  control = list(...),
  ...,
  all_or_none = deprecated(),
  verbose = FALSE
)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; data can be coerced into a \code{data.frame}. If performing an
\code{update}, \code{upsert}, or \code{delete} operation, then one column or
field must be the \code{Id} of the record to modify or delete.}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used along with \code{anytime()} and \code{anydate()}.
If \code{FALSE} then all fields will be returned as character. Specifying
\code{FALSE} helpful when guessing the column data type will result in NA
values and you would like to return the results as strings and then cast in
your script according to your unique specifications.}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream
to \code{\link{sf_bulk_operation}}}

\item{all_or_none}{\code{logical}; allows a call to roll back all changes unless all
records are processed successfully.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Adds one or more new records to your organization’s data.
}
\note{
Because the SOAP and REST calls chunk data into batches of 200 records
the AllOrNoneHeader will only apply to the success or failure of every batch
of records and not all records submitted to the function.
}
\examples{
\dontrun{
n <- 2
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_recs1 <- sf_create(new_contacts, object_name = "Contact")

# add control to allow the creation of records that violate a duplicate rules
new_recs2 <- sf_create(new_contacts, object_name = "Contact", 
                       DuplicateRuleHeader=list(allowSave=TRUE,
                                                includeRecordDetails=FALSE,
                                                runAsCurrentUser=TRUE))
                                                  
# example using the Bulk 1.0 API to insert records
new_recs3 <- sf_create(new_contacts, object_name = "Contact", 
                       api_type = "Bulk 1.0")
}
}
