% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_safeframe.R
\name{make_safeframe}
\alias{make_safeframe}
\title{Create a safeframe from a data.frame}
\usage{
make_safeframe(.data, ...)
}
\arguments{
\item{.data}{a \code{data.frame} or a \code{tibble}}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A series of tags provided as
\code{tag_name = "column_name"}}
}
\value{
The function returns a \code{safeframe} object.
}
\description{
This function converts a \code{data.frame} or a \code{tibble} into a \code{safeframe}
object, where data are tagged and validated. The output will seem to be the
same \code{data.frame}, but \code{safeframe}-aware packages will then be able to
automatically use tagged fields for further data cleaning and analysis.
}
\examples{

x <- make_safeframe(cars,
  mph = "speed",
  distance = "dist"
)

## print result - just first few entries
head(x)

## check tags
tags(x)

## tags can also be passed as a list with the splice operator (!!!)
my_tags <- list(
  mph = "speed",
  distance = "dist"
)
new_x <- make_safeframe(cars, !!!my_tags)

## The output is strictly equivalent to the previous one
identical(x, new_x)

}
\seealso{
\itemize{
\item An overview of the \link{safeframe} package
\item \code{\link[=tags]{tags()}}: for a list of tagged variables in a \code{safeframe}
\item \code{\link[=set_tags]{set_tags()}}: for modifying tags
\item \code{\link[=tags_df]{tags_df()}}: for selecting variables by tags
}
}
