% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exCopdab}
\alias{exCopdab}
\title{Dynamic Foreign Policy Behavior (COPDAB)}
\format{
A data frame with 372 observations on the following 12 variables.
\describe{
\item{\code{ym}}{a year-month indicator, in the format of YYMM}
\item{\code{eg2is}}{an estimate of the dyadic foreign policy behavior of Egypt to Israel}
\item{\code{is2eg}}{an estimate of the dyadic foreign policy behavior of Israel to Egypt}
\item{\code{us2ussr}}{an estimate of the dyadic foreign policy behavior of the U.S. to the Soviet Union}
\item{\code{ussr2us}}{an estimate of the dyadic foreign policy behavior of the Soviet Union to the U.S.}
\item{\code{us2fra}}{an estimate of the dyadic foreign policy behavior of the U.S. to France}
\item{\code{fra2us}}{an estimate of the dyadic foreign policy behavior of France to the U.S.}
\item{\code{us2is}}{an estimate of the dyadic foreign policy behavior of the U.S. to Israel}
\item{\code{is2us}}{an estimate of the dyadic foreign policy behavior of Israel to the U.S.}
\item{\code{suez}}{a dummy variable indicating if the observation corresponds with the Suez Crisis}
\item{\code{sixday}}{a dummy variable indicating if the observation corresponds with the Six-Day War}
\item{\code{yomk}}{a dummy variable indicating if the observation corresponds with the Yom Kippur War}
}
}
\usage{
exCopdab
}
\description{
A data frame on monthly dyadic foreign policy behavior from 1948 to 1978 for
select dyads, using COPDAB data. The data offer the opportunity for a basic
replication of Lebo and Moore (2003).
}
\details{
Lebo and Moore (2003, 22-24) will offer more context about how these
variables are coded. Important details for replication from scratch are assuredly
lost to history, but the authors are clear about what they're doing and the
procedure they used to weight fundamentally ordinal data to create some kind
of continuous estimate. Context clues offer more information as well.
}
\references{
Lebo, Matthew J. and Will H. Moore. 2003. "Dynamic Foreign Policy Behavior."
\emph{Journal of Conflict Resolution} 47(1): 13-32.
}
\keyword{datasets}
