% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elu.R
\name{ELU}
\alias{ELU}
\title{Exponential Linear Unit (ELU) Activation Function}
\usage{
ELU(x, alpha = 1)
}
\arguments{
\item{x}{A numeric vector. All elements must be finite and
non-missing.}

\item{alpha}{A numeric scalar. All elements must be finite and
non-missing.}
}
\value{
A numeric vector where the ReLU function has been applied
to each element of \code{x}.
}
\description{
Exponential Linear Unit (ELU) Activation Function
}
\examples{

ELU(c(-1, 0, 1, 2), 2)

# Can also be used in rxode2:
x <- rxode2({
   r=SELU(time)
})

e <- et(c(-1, 0, 1, 2))

rxSolve(x, e)

}
\seealso{
Other Activation Functions: 
\code{\link{GELU}()},
\code{\link{PReLU}()},
\code{\link{ReLU}()},
\code{\link{SELU}()},
\code{\link{Swish}()},
\code{\link{dELU}()},
\code{\link{dGELU}()},
\code{\link{dPReLU}()},
\code{\link{dReLU}()},
\code{\link{dSELU}()},
\code{\link{dSwish}()},
\code{\link{dlReLU}()},
\code{\link{dsoftplus}()},
\code{\link{lReLU}()},
\code{\link{softplus}()}
}
\author{
Matthew Fidler
}
\concept{Activation Functions}
