#' MrBayes output from analysis of Hibbett et al. data
#' 
#' This is the output from a MrBayes run of 10,000,000 generations using the analysis settings from the original .nex file.  
#' Sampling is one tree per 40,000 generations.  Four chains are included, each with its associated log file.
#'
#' @references Study reference: Hibbett D., Pine E., Langer E., Langer G., & Donoghue M. 1997. Evolution of gilled
#' mushrooms and puffballs inferred from ribosomal DNA sequences. Proceedings of
#' the National Academy of Sciences of the United States of America, 94(22): 12002-12006.
#' 
#' http://treebase.org/treebase-web/search/study/summary.html?id=271
#' 
#' @docType data
#' @keywords datasets
#' @name fungus
#' @usage data(fungus)
#' @format A data frame with four chains of 251 phylogenetic trees and associated likelihood and parameter values.

NULL


