% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_uniform_model.R
\name{fit_uniform_model}
\alias{fit_uniform_model}
\title{Fit model using uniform imputation}
\usage{
fit_uniform_model(
  participant_level_data,
  obs_level_data,
  maxit = 1000,
  tolerance = 1e-08,
  n_imputations = 10
)
}
\arguments{
\item{participant_level_data}{a data.frame or tibble with the following variables:
\itemize{
\item ID: participant ID
\item E: study enrollment date
\item L: date of last negative test for seroconversion
\item R: date of first positive test for seroconversion
\item Cohort` (optional): this variable can be used to stratify the modeling of
the seroconversion distribution.
}}

\item{obs_level_data}{a data.frame or tibble with the following variables:
\itemize{
\item ID: participant ID
\item O: biomarker sample collection dates
\item Y: MAA classifications (binary outcomes)
}}

\item{maxit}{maximum iterations, passed to \code{bigglm}}

\item{tolerance}{convergence criterion, passed to \code{bigglm}}

\item{n_imputations}{number of imputed data sets to create}
}
\value{
a vector of logistic regression coefficient estimates
}
\description{
Fit model using uniform imputation
}
\examples{
sim_data = simulate_interval_censoring(
  "theta" = c(0.986, -3.88),
  "study_cohort_size" = 4500,
  "preconversion_interval_length" = 365,
  "hazard_alpha" = 1,
  "hazard_beta" = 0.5)

theta_est_midpoint = fit_uniform_model(
  obs_level_data = sim_data$obs_data,
  participant_level_data = sim_data$pt_data
)

}
