% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win.R
\name{r_release_win}
\alias{r_release_win}
\title{Latest R release with a Windows installer available for download}
\usage{
r_release_win()
}
\value{
A one row data frame, with columns \sQuote{version},
\sQuote{date}, \sQuote{URL} and \sQuote{nickname}.
}
\description{
\code{\link[=r_release]{r_release()}} works based on the SVN tags in the main R source code
repository. However, an SVN tag does not mean that the same version
is available for download. \code{r_release_win} returns the latest
version for which a Windows installer is available.
}
\section{Note}{

This function is superseded by \code{\link[=resolve]{resolve()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{r_release_win()
#> # A data frame: 1 x 5
#>   version date                nickname          semver     URL                  
#>   <chr>   <dttm>              <chr>             <pckg_vrs> <chr>                
#> 1 4.5.1   2025-06-13 07:12:01 Great Square Root 4.5.1      https://cran.rstudio~
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{resolve("release", platform = "windows")
#> # A data frame: 1 x 7
#>   version date                nickname          semver    url   type  rtools_url
#>   <chr>   <dttm>              <chr>             <pckg_vr> <chr> <chr> <chr>     
#> 1 4.5.1   2025-06-13 07:12:01 Great Square Root 4.5.1     http~ rele~ https://g~
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (rversions:::is_online()) withAutoprint(\{ # examplesIf}
r_release()
r_release_win()
\dontshow{\}) # examplesIf}
}
\seealso{
Other R downloads: 
\code{\link{r_release_macos}()},
\code{\link{r_release_tarball}()}
}
\concept{R downloads}
