% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dnbinom_rvec}
\alias{dnbinom_rvec}
\alias{pnbinom_rvec}
\alias{qnbinom_rvec}
\alias{rnbinom_rvec}
\title{Negative Binomial Distribution, Using Multiple Draws}
\usage{
dnbinom_rvec(x, size, prob, mu, log = FALSE)

pnbinom_rvec(q, size, prob, mu, lower.tail = TRUE, log.p = FALSE)

qnbinom_rvec(p, size, prob, mu, lower.tail = TRUE, log.p = FALSE)

rnbinom_rvec(n, size, prob, mu, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{size}{Number of trials.
See \code{\link[=dnbinom]{dnbinom()}}. Can be an rvec.}

\item{prob}{Probability of success in each trial.
See \code{\link[=dnbinom]{dnbinom()}}. Can be an rvec.}

\item{mu}{Mean value. See \code{\link[=dnbinom]{dnbinom()}}.
Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}; otherwise an ordinary R vector.
\item Unlike base \code{rbinom()}, \code{rnbinom_rvec()}
always returns doubles.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
negative binomial distribution, modified to work with
rvecs.
}
\details{
Functions \code{dnbinom_rvec()}, \code{pnbinom_rvec()},
\code{pnbinom_rvec()} and \code{rnbinom_rvec()} work like
base R functions \code{\link[=dnbinom]{dnbinom()}}, \code{\link[=pnbinom]{pnbinom()}},
\code{\link[=qnbinom]{qnbinom()}}, and \code{\link[=rnbinom]{rnbinom()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rnbinom_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dnbinom_rvec()}, \code{pnbinom_rvec()},
\code{pnbinom_rvec()} and \code{rnbinom_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3, 5),
               c(0, 2)))
dnbinom_rvec(x, size = 6, prob = 0.2)
pnbinom_rvec(x, size = 6, prob = 0.2)

rnbinom_rvec(n = 2,
             size = 2,
             mu = c(4, 8),
             n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dnbinom]{dnbinom()}}, \code{\link[=pnbinom]{pnbinom()}}, \code{\link[=qnbinom]{qnbinom()}}, \code{\link[=rnbinom]{rnbinom()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
