% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rutledge.R
\name{rutledge}
\alias{rutledge}
\title{qPCR data set by Rutledge et al. (2004)}
\format{
A \link[tibble:tibble-package]{tibble} with 10,800 rows and 10 variables:
\describe{
\item{\code{plate}}{Plate identifier. Because one plate (run) was used per
dilution series, \code{plate} values are simply numbered 1 thru 5.}
\item{\code{well}}{Well identifier. Values are always \code{NA} (not available). This
variable is kept nevertheless to be coherent with other data sets from other
similar R data packages.}
\item{\code{dye}}{The type of dye used. In this data set the values are always
\code{"SYBR"}, meaning SYBR Green I master mix (Roche).}
\item{\code{target}}{Target identifier: the amplicon used, K1/K2 or K3/K2.}
\item{\code{sample_type}}{Sample type (all curves are standards, i.e. \code{"std"}).}
\item{\code{replicate}}{Replicate identifier: 1 thru 4.}
\item{\code{copies}}{Standard copy number.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1093/nar/gnh177}
}
\description{
Each data set comprises a six-point, ten-fold dilution series, repeated in
five independent runs, for two different amplicons: K1/K2, 102 bp, and K3/K2,
218 bp.
Fluorescence readings were exported after background subtraction via baseline
averaging of the 5 cycles immediately preceding the cycles in which
fluorescence was first detected. Please read the Materials and Methods
section of Rutledge et al. (2004) for more details.
}
\examples{
rutledge

}
\keyword{datasets}
