% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runcharter.R
\name{runcharter}
\alias{runcharter}
\title{runcharter}
\usage{
runcharter(
  df,
  med_rows = 13,
  runlength = 9,
  direction = c("above", "below", "both"),
  datecol = NULL,
  grpvar = NULL,
  yval = NULL,
  facet_cols = NULL,
  facet_scales = "fixed",
  chart_title = NULL,
  chart_subtitle = NULL,
  chart_caption = NULL,
  chart_breaks = NULL,
  line_colr = "#005EB8",
  line_size = 1.1,
  point_colr = "#005EB8",
  point_size = 2.5,
  median_colr = "#E87722",
  median_line_size = 1.05,
  highlight_fill = "#DB1884",
  highlight_point_size = 2.7
)
}
\arguments{
\item{df}{data.frame or data table}

\item{med_rows}{number of points to calculate initial baseline median}

\item{runlength}{length of run that will trigger re-phased median}

\item{direction}{should run occur "above", "below" or on "both" sides of median}

\item{datecol}{name of date column}

\item{grpvar}{character vector of grouping variable}

\item{yval}{numeric y value}

\item{facet_cols}{how many columns are required in the plot facets}

\item{facet_scales}{defaults to "fixed". Alternatively, "free_y"}

\item{chart_title}{title for the  final chart}

\item{chart_subtitle}{subtitle for chart}

\item{chart_caption}{caption for chart}

\item{chart_breaks}{character string defining desired x-axis date / datetime breaks.
If the x axis is not a Date or datetime, then this argument is ignored, 
and ggplot2 will provide default breaks}

\item{line_colr}{colour for run chart lines}

\item{line_size}{thickness of connecting lines between run chart points}

\item{point_colr}{colour for run chart points}

\item{point_size}{size of normal run chart points}

\item{median_colr}{colour for solid and extended median lines}

\item{median_line_size}{thickness of solid and extended median lines}

\item{highlight_fill}{fill colour for highlighting points in a sustained run}

\item{highlight_point_size}{size of highlighted points in a sustained run}
}
\value{
list - faceted plot and data.table showing all identified runs
}
\description{
Finds all runs of desired  length occurring on desired side of median line.
Can also find runs occurring on both sides of the line, though this is of
limited use in terms of quality improvement.
Re-bases median each time a run is discovered.
}
\details{
Facets and axis limits are handled by ggplot, though x-axis breaks can be
specified using the appropriate character string e.g. "3 months" if they are
either of class dates or datetime
}
\examples{
\donttest{
runcharter(signals, med_rows = 13, runlength = 9,
direction = "above", datecol = date, grpvar = grp, yval = y,
facet_cols = 2,chart_title = "Automated runs analysis",
chart_subtitle = " some runs found", chart_caption = "powered by R",
chart_breaks = "6 months")
}



}
