% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{vcov.trim}
\alias{vcov.trim}
\title{Extract variance-covariance matrix from TRIM output}
\usage{
\method{vcov}{trim}(object, which = c("imputed", "fitted"), ...)
}
\arguments{
\item{object}{TRIM output structure (i.e., output of a call to \code{trim})}

\item{which}{\code{[character]} Selector to distinguish between variance-covariance based on the
imputed counts (default), or the fitted counts.}

\item{...}{Arguments to pass to or from other methods (currently unused; included for consistency with \code{\link[stats]{vcov}}).}
}
\value{
a J x J matrix, where J is the number of years (or time-points).
}
\description{
Extract variance-covariance matrix from TRIM output
}
\examples{
data(skylark)
z <- trim(count ~ site + time, data=skylark, model=3);
totals(z)
vcv1 <- vcov(z)          # Use imputed data
vcv2 <- vcov(z,"fitted") # Use fitted data
}
\seealso{
Other analyses: 
\code{\link{coef.trim}()},
\code{\link{confint.trim}()},
\code{\link{gof}()},
\code{\link{index}()},
\code{\link{now_what}()},
\code{\link{overall}()},
\code{\link{overdispersion}()},
\code{\link{plot.trim.index}()},
\code{\link{plot.trim.overall}()},
\code{\link{plot.trim.smooth}()},
\code{\link{results}()},
\code{\link{serial_correlation}()},
\code{\link{summary.trim}()},
\code{\link{totals}()},
\code{\link{trendlines}()},
\code{\link{trim}()},
\code{\link{wald}()}
}
\concept{analyses}
