% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelines_statuses.R
\name{get_timeline_public}
\alias{get_timeline_public}
\title{Get the public timeline}
\usage{
get_timeline_public(
  local = FALSE,
  remote = FALSE,
  only_media = FALSE,
  max_id,
  since_id,
  min_id,
  limit = 20L,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  parse = TRUE,
  retryonratelimit = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{local}{logical, Show only local statuses?}

\item{remote}{logical, Show only remote statuses?}

\item{only_media}{logical, Show only statuses with media attached?}

\item{max_id}{character or \code{POSIXct} (date time), Return results older than this id}

\item{since_id}{character or \code{POSIXct} (date time), Return results newer than this id}

\item{min_id}{character or \code{POSIXct} (date time), Return results immediately newer than this id}

\item{limit}{integer, Maximum number of results to return}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{some API calls do not need a token. Setting anonymous to TRUE allows to make an anonymous call if possible.}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}

\item{retryonratelimit}{If TRUE, and a rate limit is exhausted, will wait until it refreshes. Most Mastodon rate limits refresh every 5 minutes. If FALSE, and the rate limit is exceeded, the function will terminate early with a warning; you'll still get back all results received up to that point.}

\item{verbose}{logical whether to display messages}
}
\value{
statuses
}
\description{
Query the instance for the public timeline
}
\details{
\code{max_id}, \code{since_id}, and \code{min_id} can either be character or \code{POSIXct} (date time). If it is \code{POSXIct}, it will be converted to the so-called snowflake ID.
}
\examples{
\dontrun{
## as tibble
get_timeline_public()
## as list
get_timeline_public(parse = FALSE)
}
}
\references{
https://docs.joinmastodon.org/methods/timelines/
}
