% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{update_project}
\alias{update_project}
\title{Update a project}
\usage{
update_project(
  project_id = get_project_id(project_name = project_name, token = token, create = FALSE),
  project_name,
  new_name = NULL,
  color = NULL,
  is_favorite = NULL,
  view_style = NULL,
  verbose = TRUE,
  token = get_todoist_api_token()
)
}
\arguments{
\item{project_id}{id of the project}

\item{project_name}{name of the project (for lookup if project_id not provided)}

\item{new_name}{new name for the project}

\item{color}{new color for the project}

\item{is_favorite}{boolean to mark as favorite}

\item{view_style}{view style ("list" or "board")}

\item{verbose}{boolean that make the function verbose}

\item{token}{todoist API token}
}
\value{
id of the updated project (invisible)
}
\description{
Update a project
}
\examples{
\dontrun{
update_project(project_name = "my_proj", new_name = "new_name")
}
}
