% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_reshape.r
\name{selected_nodes}
\alias{selected_nodes}
\title{If select_nodes() is used, the selected nodes can be extracted with selected_nodes().
This is mainly for internal use, but it can also be usefull for debugging, and to controll
loops of reshape operation (e.g. break if no selected nodes left)}
\usage{
selected_nodes(.tokens)
}
\arguments{
\item{.tokens}{A tokenIndex in which nodes are selected with \link{select_nodes}.}
}
\value{
A tokenIndex with a .nodes attribute
}
\description{
If select_nodes() is used, the selected nodes can be extracted with selected_nodes().
This is mainly for internal use, but it can also be usefull for debugging, and to controll
loops of reshape operation (e.g. break if no selected nodes left)
}
\examples{
tokens = tokens_spacy[tokens_spacy$doc_id == 'text4',]

## use a tquery to label the nodes that you want to manipulate
tq = tquery(relation = "relcl", label = "relative_clause")

## apply query to select nodes
tokens2 = select_nodes(tokens, tq) 

## Get selected nodes from tokenindex
selected_nodes(tokens2)
}
